<?php
/*
Plugin Name: Custom Login Area
Plugin URI: https://danielfarias.net.br
Description: Personaliza a área de login do WordPress, permitindo definir um fundo personalizado.
Version: 1.2
Author: Daniel Farias Agência Digital
Author URI: https://danielfarias.net.br
License: GPLv2 or later
Text Domain: custom-login-area
*/

// Adiciona o CSS personalizado
function custom_login_styles() {
    wp_enqueue_style('custom-login', plugin_dir_url(__FILE__) . 'custom-login.css');
    
    $background_image = get_option('custom_login_background');
    if ($background_image) {
        echo '<style>
            .language-switcher {
                background-image: url(' . esc_url($background_image) . ') !important;
            }
        </style>';
    }
}
add_action('login_enqueue_scripts', 'custom_login_styles');

// Personaliza o logo na tela de login
function site_logo() {
    $site_logo_url = get_theme_mod('custom_logo');
    $logo = wp_get_attachment_image_src($site_logo_url, 'full');
    if ($logo) {
        echo '<style>
            h1 a {
                background-image: url(' . esc_url($logo[0]) . ') !important;
                width: 275px !important;
                height: 150px !important;
                margin: 0 auto 7px !important;
                background-size: contain !important;
                background-position: center !important;
            }
        </style>';
    }
}
add_action('login_head', 'site_logo');

// Adiciona uma opção no painel para definir o fundo da tela de login
function custom_login_settings_menu() {
    add_menu_page('Custom Login', 'Custom Login', 'manage_options', 'custom-login-settings', 'custom_login_settings_page');
}
add_action('admin_menu', 'custom_login_settings_menu');

function custom_login_settings_page() {
    if (isset($_POST['custom_login_background'])) {
        update_option('custom_login_background', esc_url_raw($_POST['custom_login_background']));
        echo '<div class="updated"><p>Imagem de fundo atualizada!</p></div>';
    }
    $background_image = get_option('custom_login_background');
    ?>
    <div class="wrap">
        <h1>Personalização da Tela de Login</h1>
        <form method="post">
            <label for="custom_login_background">URL da imagem de fundo:</label>
            <input type="text" name="custom_login_background" id="custom_login_background" value="<?php echo esc_attr($background_image); ?>" style="width:100%; max-width:600px;" />
            <p><input type="submit" value="Salvar" class="button button-primary" /></p>
        </form>
    </div>
    <?php
}
